<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Session;
use Response;
use Redirect;
use Illuminate\Support\Facades\Input;
use View;
use Config;
use App\Models\TblResult;

class PagesController extends Controller  {


    public function index()
    {
        #set default values
        Session::put('ShowPeriod', 1);
        Session::put('ShowRD', 3);
		$lastResult = TblResult::where('tabtype','=','parity')->orderBy('createdate','desc')->first()->toArray();
		
		return view('welcome', compact('lastResult'));
	}
	public function getResults()
    {
		$totalCounts = array('red' => 0, 'green' => 0, 'violet' => 0);
    	$results = $this->getRecords();
		$green = $red = $violet = 0;
		$i = 0;
		$lastRecordColor = '';
		$resultData = array();
		$mxColumn = 0;
		if(count($results) > 0){
			foreach($results as $result){
				# set result page
                if($result['resulttype'] == 'random'){
                    $explodColor = explode('++',strtolower($result['randomcolor']));
                    if($result['randomcolor'] == 'RED & VIOLET' || $result['randomcolor'] == 'GREEN & VIOLET'){
                        $explodColor = explode(' & ',strtolower($result['randomcolor']));
                    }
                    if($result['color'] == 'green+violet' || $result['color'] == 'red+violet'){
                        $explodColor = explode('+',strtolower($result['color']));
                    }

                    if($lastRecordColor == strtolower($result['randomcolor']) || (isset($explodColor[0]) && strtolower($explodColor[0]) == $lastRecordColor)){
                        $resultData[$i][] = $result;
                        $lastRecordColor = isset($explodColor[0])?strtolower($explodColor[0]):strtolower($result['randomcolor']);
                    }else{
                        $i++;
                        $resultData[$i][] = $result;
                        $lastRecordColor = isset($explodColor[0])?strtolower($explodColor[0]):strtolower($result['randomcolor']);
                    }

                    #set total counts
                    if(strtolower($result['randomcolor'] )== 'green'){
                        $green++;
                    }else if(strtolower($result['randomcolor']) == 'red'){
                        $red++;
                    }else{
                        $violet++;
                    }

                }else{
                    $explodColor = explode('++',strtolower($result['color']));
                    if($result['color'] == 'RED & VIOLET' || $result['color'] == 'GREEN & VIOLET'){
                        $explodColor = explode(' & ',strtolower($result['color']));
                    }
                    if($result['color'] == 'green+violet' || $result['color'] == 'red+violet'){
                        $explodColor = explode('+',strtolower($result['color']));
                    }
                    if($lastRecordColor == strtolower($result['color']) || (isset($explodColor[0]) && strtolower($explodColor[0]) == $lastRecordColor)){
                        $resultData[$i][] = $result;
                        $lastRecordColor = isset($explodColor[0])?strtolower($explodColor[0]):strtolower($result['color']);
                    }else{
                        $i++;
                        $resultData[$i][] = $result;
                        $lastRecordColor = isset($explodColor[0])?strtolower($explodColor[0]):strtolower($result['color']);
                    }

                    #set total counts
                    if(strtolower($result['color'] )== 'green'){
                        $green++;
                    }else if(strtolower($result['color']) == 'red'){
                        $red++;
                    }else{
                        $violet++;
                    }

                }

			}

			#get mxColumn
			if(count($resultData) > 0){
				foreach($resultData as $rsltData){
					if(count($rsltData) > $mxColumn){
						$mxColumn = count($rsltData);
					}
				}
			}

			$totalCounts = array('red' => $red, 'green' => $green, 'violet' => $violet);
		}
		//echo '<pre />';
		//print_r($resultData);die;
        $ShowPeriod = Session::get('ShowPeriod');
        $ShowRD = Session::get('ShowRD');
		$lastResult = TblResult::where('tabtype','=','parity')->orderBy('createdate','desc')->first()->toArray();
		
		$totalRed1 = $this->getTotal('red');
		$totalRed2 = $this->getTotal('RED & VIOLET');
		$totalRed3 = $this->getTotal('red++violet');
		$totalRed = $totalRed1 + $totalRed2 + $totalRed3;
		
		$totalGreen1 = $this->getTotal('green');
		$totalGreen2 = $this->getTotal('green++violet');
		$totalGreen3 = $this->getTotal('GREEN & VIOLET');
		$totalGreen = $totalGreen1 + $totalGreen2 + $totalGreen3;

		return view('get_results', compact('lastResult','totalCounts','resultData','mxColumn', 'results', 'ShowPeriod', 'ShowRD','totalRed','totalGreen'));
	}

	 public function getColumnRecords(Request $request)
    {
		$columnNo = $request->post('columNo')?$request->post('columNo'):3;
        Session::put('ShowRD', $columnNo);
    	$results = $this->getRecords();
		return view('column_records', compact('results', 'columnNo'));
	}

	private function getRecords(){
		$results = TblResult::where('tabtype','=','parity')->take(480)->orderBy('id', 'desc')->get()->toArray();
		asort($results);
        return $results;
	}
	
	private function getTotal($randomColor=null){
		$results = TblResult::where('tabtype','=','parity')
		    ->where('randomcolor',$randomColor)
		    ->count();
        return $results;
	}
   
	
    public function setShowPeriod(Request $request)
    {
        #set default values
        $ShowPeriod = $request->post('rowId')?$request->post('rowId'):1;
        Session::put('ShowPeriod', $ShowPeriod);
       return 'Success';
	}
}
?>
