<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dubai Mall - Trend</title>
    <link href="<?php echo e(asset('public/assets/css/bootstrap.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('public/assets/css/custom.css')); ?>" rel="stylesheet">
    <script type="text/javascript" src="<?php echo e(asset('public/assets/js/jquery-3.6.0.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('public/assets/js/bootstrap.min.js')); ?>"></script>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css">
    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
<script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
<style>
body{font-family: Helvetica}
.center {
  margin: 0 auto;
  text-align: center;
}
.nav-tabs {
	background:#fff;
	border-radius:0px;
	border:0;
	padding:5px 3px 5px 3px
}
.nav-tabs .nav-item {
	text-align:center
}
.nav-tabs .nav-item i {
	font-size:20px;
	margin-bottom:-2px
}
.nav-tabs.iconed .nav-item i {
	margin-right:8px
}
.nav-tabs .nav-link {
	height:44px;
	display:-webkit-box;
	display:flex;
	-webkit-box-align:center;
	align-items:center;
	-webkit-box-pack:center;
	justify-content:center;
	background:transparent;
	color:#CBCBCB;
	padding:0 16px;
	border-top:none;
	border-left:none;
	border-right:none;
	border-radius:0px;
	margin:0 !important;
	font-weight:500;
  font-size: 16px;
  border-bottom: 2px solid #CBCBCB;
}
 .nav-tabs .nav-link:hover {
	background:#ffffff;
	color: #009688;
	 border-bottom: 2px solid #009688; 
} 


.nav-tabs.size1, .nav-tabs.size2, .nav-tabs.size3, .nav-tabs.size4, .nav-tabs.size5, .nav-tabs.size6 {
	display:-webkit-box;
	display:flex;
	-webkit-box-align:center;
	align-items:center;
	-webkit-box-pack:center;
	justify-content:center
}
.nav-tabs.size1 .nav-item {
	width:100%
}
.nav-tabs.size2 .nav-item {
	width:50%
}
.nav-tabs.size3 .nav-item {
	width:33.333333333333%
}
.nav-tabs.size4 .nav-item {
	width:25%
}
.nav-tabs.size5 .nav-item {
	width:20%
}
.nav-tabs.size6 .nav-item {
    width:16.66%
}
	
 .header {
    position: relative;
    z-index: 1;
    display: -webkit-box;
    display: -webkit-flex;
    display: flex;
    -webkit-box-align: center;
    -webkit-align-items: center;
    align-items: center;
    height: 46px;
    line-height: 1.5;
    text-align: center;
    background-color: #fff;
    -webkit-user-select: none;
    user-select: none;
    border-bottom: 1px solid #cccccc;
}
.jumbotronn {
    padding-top: 5px;
    padding-bottom: 1px;
    margin-bottom: 0px;
    color: inherit;
    background-color: #ffffff;
}
.column {
  
  width: calc(100% / 3);
   /* Should be removed. Only for demonstration */
}

/* Clear floats after the columns */
.row1:after {
  content: "";
  display: table;
  clear: both;
}

</style>
</head>
<body>
<div class="header">
    <span style="font-weight:500; color: #323233; font-size: 16px;" class="center">Parity Record</span>
</div>


<div id="getResult">
<div class="jumbotron">
  <div class="container">
    <div class="row">
        <div class="col-sm-12 col-xs-4">
        <p style="">Period <span style="font-weight:400; font-size:20px;"><?php echo e($lastResult['periodid'] + 1); ?></span></p>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-4 col-xs-4 result">
            <p>PrePeriod <span style="font-weight:400; font-size:20px;"><?php echo e($lastResult['periodid']); ?></span></p>
        </div>
        <div  style="margin-left:25px;" class="col-sm-4 col-xs-4 price-section">
        <?php
            $textColor = 'Red';
        ?>
        <?php if($lastResult['resulttype'] == 'random'): ?>
            <?php if($lastResult['randomcolor'] == 'green'): ?>
                <?php  $textColor = 'Green'; ?>
            <?php elseif($lastResult['randomcolor'] == 'green++violet'): ?>
                <?php  $textColor = 'VioletGreen'; ?>
            <?php elseif($lastResult['randomcolor'] == 'red++violet'): ?>
                <?php  $textColor = 'VioletRed'; ?>
            <?php endif; ?>
        <?php endif; ?>
        <?php if($lastResult['resulttype'] == 'real'): ?>
            <?php if($lastResult['color'] == 'green'): ?>
                <?php  $textColor = 'Green'; ?>
            <?php elseif($lastResult['color'] == 'green++violet'): ?>
                <?php  $textColor = 'VioletGreen'; ?>
            <?php elseif($lastResult['color'] == 'red++violet'): ?>
                <?php  $textColor = 'VioletRed'; ?>
            <?php endif; ?>
        <?php endif; ?>
            <p>Result <span class="item<?php echo e($textColor); ?>" style="font-size:16px"><?php echo e($lastResult['resulttype'] == 'random' ? $lastResult['randomresult']:$lastResult['result']); ?></span></p>
        </div>
        <div class="">
            <p>OpenPrice <span style="font-weight:400; font-size:20px; color: #e839f1;"><?php echo e($lastResult['randomprice']); ?></span></p>
        </div>
    </div>
  </div>
</div>
</div>
</body>
<script>
$(document).ready(function(){
    getResult();

});
function getResult(){
    $.ajax({
        type: 'POST',
        url: '<?php echo e(url("/get-records")); ?> ',
        data: {"_token": "<?php echo e(csrf_token()); ?>"},
        success: function(msg){
            $('#getResult').html(msg);
            //setTimeout(getResult, 180000);
            $('.resultBox').animate({scrollLeft: 1000000000}, 500);
        }
    });
}
</script>
</html>
<?php /**PATH /home4/dubaimal/public_html/trend/resources/views/welcome.blade.php ENDPATH**/ ?>