<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Wingo Plus - Trend</title>
    <link href="<?php echo e(asset('public/assets/css/bootstrap.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('public/assets/css/custom.css')); ?>" rel="stylesheet">
    <script type="text/javascript" src="<?php echo e(asset('public/assets/js/jquery-3.6.0.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('public/assets/js/bootstrap.min.js')); ?>"></script>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css">
    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
<script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <style>.appBottomMenu {
	min-height:56px;
	position:fixed;
	z-index:9999;
	bottom:0;
	left:0;
	right:0;
	background:#FFF;
	display:-webkit-box;
	display:flex;
	-webkit-box-align:center;
	align-items:center;
	-webkit-box-pack:center;
	justify-content:center;
	padding-bottom:env(safe-area-inset-bottom);
	-webkit-box-shadow: 0 3px 14px 2px rgba(0, 0, 0, .12);
	box-shadow: 0 3px 14px 2px rgba(0, 0, 0, .12);
}
.appBottomMenu .item {
	width:35%;
	text-align:center;
	height:56px;
	display:-webkit-box;
	display:flex;
	-webkit-box-align:center;
	align-items:center;
	-webkit-box-pack:center;
	justify-content:center
}
.appBottomMenu .item>a {
	width:100%;
	height:56px;
	display:-webkit-box;
	display:flex;
	-webkit-box-align:center;
	align-items:center;
	padding:0;
	-webkit-box-pack:center;
	justify-content:center;
	color:#1B2C42 !important;
	position:relative
}
.appBottomMenu .item p {
	margin:0
}
.appBottomMenu .item i {
	font-size:26px;
	line-height:0;
	margin-bottom:17px;
	display:block
}
.appBottomMenu .item span {
	display:block;
	font-size:11px;
	position:absolute;
	left:0;
	bottom:2px;
	right:0
}
.appBottomMenu .item.active {
	position:relative
}
/*.appBottomMenu .item.active:after {
	content:'';
	height:2px;
	border-radius:0 0 10px 10px;
	display:block;
	background:#D43D46;
	position:absolute;
	left:0;
	top:0;
	right:0
}*/
.appBottomMenu .item.active>a {
	color:#D43D46 !important
}
.appBottomMenu.iconed .item i {
	margin-bottom:0
}
.appBottomMenu.color-light {
	border-top:0
}
.appBottomMenu.color-light .item>a {
	color:rgba(255, 255, 255, 0.7) !important
}
.appBottomMenu.color-light .item.active:after {
	background:transparent
}
.appBottomMenu.color-light .item.active>a {
	color:#FFF !important
}
.jumbotronn {
    padding-top: 5px;
    padding-bottom: 1px;
    margin-bottom: 0px;
    color: inherit;
    background-color: #F8F9FA;
}
</style>
</head>
<body>
<div class="" style="	padding: 0 24px;
	height:55px;
background-image: linear-gradient(to bottom right, #D43D46, #DB0477);
	border-color: #2196f3;
	-webkit-box-shadow: 0 2px 4px -1px rgba(0, 0, 0, .2), 0 4px 5px 0 rgba(0, 0, 0, .14), 0 1px 10px 0 rgba(0, 0, 0, .12);
	box-shadow: 0 2px 4px -1px rgba(0, 0, 0, .2), 0 4px 5px 0 rgba(0, 0, 0, .14), 0 1px 10px 0 rgba(0, 0, 0, .12);">
  <div class=""> 
    <div style="	line-height:3em;
	font-size: 20px;
	font-weight: 500;
	letter-spacing: .02em;
	white-space: nowrap;

	text-overflow: ellipsis;
	color:#fff;"><a href="/win.php"><i  style="text-decoration: none; padding-right:15px;" class="icon"><i  style="text-decoration: none; color:white; font-size: 20px; font-weight:300;margin-left:-10px;" class="fa fa-arrow-left"></i></i></a>Parity Trend</div>
  </div>
</div>

<div id="getResult">
<div class="jumbotron">
  <div class="container">
    <div class="row">
        <div class="col-sm-12 col-xs-4">
        <p style="">Period <span><?php echo e($lastResult['periodid'] + 1); ?></span></p>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-4 col-xs-4 result">
            <p>Preperiod <span><?php echo e($lastResult['periodid']); ?></span></p>
        </div>
        <div class="col-sm-4 col-xs-4 price-section">
        <?php
            $textColor = 'Red';
        ?>
        <?php if($lastResult['resulttype'] == 'random'): ?>
            <?php if($lastResult['randomcolor'] == 'green'): ?>
                <?php  $textColor = 'Green'; ?>
            <?php elseif($lastResult['randomcolor'] == 'green++violet'): ?>
                <?php  $textColor = 'VioletGreen'; ?>
            <?php elseif($lastResult['randomcolor'] == 'red++violet'): ?>
                <?php  $textColor = 'VioletRed'; ?>
            <?php endif; ?>
        <?php endif; ?>
        <?php if($lastResult['resulttype'] == 'real'): ?>
            <?php if($lastResult['color'] == 'green'): ?>
                <?php  $textColor = 'Green'; ?>
            <?php elseif($lastResult['color'] == 'green++violet'): ?>
                <?php  $textColor = 'VioletGreen'; ?>
            <?php elseif($lastResult['color'] == 'red++violet'): ?>
                <?php  $textColor = 'VioletRed'; ?>
            <?php endif; ?>
        <?php endif; ?>
            <p>Result <span class="item<?php echo e($textColor); ?>" style="font-size:16px"><?php echo e($lastResult['resulttype'] == 'random' ? $lastResult['randomresult']:$lastResult['result']); ?></span></p>
        </div>
        <div class="col-sm-4 col-xs-4">
            <p>OpenPrice <span><?php echo e($lastResult['randomprice']); ?></span></p>
        </div>
    </div>
  </div>
</div>
</div>
<div class="appBottomMenu">
 

    
   
  
  
   <div class="item "> <a href="/index">
    <p> <i  style="text-decoration: none;" class="icon"><i  style="text-decoration: none; font-size: 20px;" class="fa fa-home"></i></i> <span>Home</span> </p>
    </a> </div>
     <div class="item"> <a href="/refer.php">
    <p> <i  style="text-decoration: none;" class="icon"><i  style="text-decoration: none; font-size: 20px;" class="fa fa-user-plus"></i></i> <span>Refer & Earn</span> </p>
    </a> </div>
    <div class="item"> <a href="/win.php">
    <p> <i  style="text-decoration: none;" class="icon"><i  style="text-decoration: none; font-size: 20px;" class="fa fa-trophy"></i></i>  <span>WinGO</span> </p>
    </a> </div>
     <div class="item "> <a href="/myaccount.php">
    <p> <i  style="text-decoration: none;" class="icon"><i  style="text-decoration: none; font-size: 20px;" class="fa fa-user"></i></i><span>My Account</span> </p>
    </a> </div>

</div>
</body>
<script>
$(document).ready(function(){
    getResult();

});
function getResult(){
    $.ajax({
        type: 'POST',
        url: '<?php echo e(url("/get-records")); ?> ',
        data: {"_token": "<?php echo e(csrf_token()); ?>"},
        success: function(msg){
            $('#getResult').html(msg);
            //setTimeout(getResult, 180000);
            $('.resultBox').animate({scrollLeft: 1000000000}, 500);
        }
    });
}
</script>
</html>
<?php /**PATH /home/wingoplu/public_html/trend/resources/views/welcome.blade.php ENDPATH**/ ?>