<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>ONO GROW</title>
    <link href="<?php echo e(asset('public/assets/css/bootstrap.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('public/assets/css/custom.css')); ?>" rel="stylesheet">
    <script type="text/javascript" src="<?php echo e(asset('public/assets/js/jquery-3.6.0.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('public/assets/js/bootstrap.min.js')); ?>"></script>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
</head>
<body>
<nav class="navbar navbar-inverse">
  <div class="container-fluid">
    <div class="navbar-header">
      <a class="navbar-brand" href="#">Star-x Result- powered by ono grow</a>
    </div>
  </div>
</nav>

<div id="getResult">
<div class="jumbotron">
  <div class="container">
    <div class="row">
        <div class="col-sm-12 col-xs-4">
        <p>Period <span><?php echo e($lastResult['periodid'] + 1); ?></span></p>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-4 col-xs-4 result">
            <p>PrePeriod <span><?php echo e($lastResult['periodid']); ?></span></p>
        </div>
        <div class="col-sm-4 col-xs-4 price-section">
        <?php
            $textColor = 'Red';
        ?>
        <?php if($lastResult['resulttype'] == 'random'): ?>
            <?php if($lastResult['randomcolor'] == 'green'): ?>
                <?php  $textColor = 'Green'; ?>
            <?php elseif($lastResult['randomcolor'] == 'green++violet'): ?>
                <?php  $textColor = 'VioletGreen'; ?>
            <?php elseif($lastResult['randomcolor'] == 'red++violet'): ?>
                <?php  $textColor = 'VioletRed'; ?>
            <?php endif; ?>
        <?php endif; ?>
        <?php if($lastResult['resulttype'] == 'real'): ?>
            <?php if($lastResult['color'] == 'green'): ?>
                <?php  $textColor = 'Green'; ?>
            <?php elseif($lastResult['color'] == 'green++violet'): ?>
                <?php  $textColor = 'VioletGreen'; ?>
            <?php elseif($lastResult['color'] == 'red++violet'): ?>
                <?php  $textColor = 'VioletRed'; ?>
            <?php endif; ?>
        <?php endif; ?>
            <p>Result <span class="item<?php echo e($textColor); ?>" style="font-size:16px"><?php echo e($lastResult['resulttype'] == 'random' ? $lastResult['randomresult']:$lastResult['result']); ?></span></p>
        </div>
        <div class="col-sm-4 col-xs-4">
            <p>OpenPrice <span class="text-<?php echo e($textColor); ?>"><?php echo e($lastResult['randomprice']); ?></span></p>
        </div>
    </div>
  </div>
</div>
</div>
</body>
<script>
$(document).ready(function(){
    getResult();

});
function getResult(){
    $.ajax({
        type: 'POST',
        url: '<?php echo e(url("/get-records")); ?> ',
        data: {"_token": "<?php echo e(csrf_token()); ?>"},
        success: function(msg){
            $('#getResult').html(msg);
            //setTimeout(getResult, 180000);
            $('.resultBox').animate({scrollLeft: 1000000000}, 500);
        }
    });
}
</script>
</html>
<?php /**PATH /home/onogrow/webapps/onogrow/onoindex/index/resources/views/welcome.blade.php ENDPATH**/ ?>