<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>WinGo Show</title>
    <link href="{{ asset('public/assets/css/bootstrap.css') }}" rel="stylesheet">
    <link href="{{ asset('public/assets/css/custom.css') }}" rel="stylesheet">
    <script type="text/javascript" src="{{ asset('public/assets/js/jquery-3.6.0.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('public/assets/js/bootstrap.min.js') }}"></script>
    <meta name="csrf-token" content="{{ csrf_token() }}" />
</head>
<body>
<nav class="navbar navbar-inverse">
  <div class="container-fluid">
    <div class="navbar-header">
      <a class="navbar-brand" href="#">Bcone Result</a>
    </div>
  </div>
</nav>

<div id="getResult">
<div class="jumbotron">
  <div class="container">
    <div class="row">
        <div class="col-sm-12 col-xs-4">
        <p>Period <span>{{ $lastResult['periodid'] + 1}}</span></p>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-4 col-xs-4 result">
            <p>PrePeriod <span>{{ $lastResult['periodid']}}</span></p>
        </div>
        <div class="col-sm-4 col-xs-4 price-section">
        @php
            $textColor = 'Red';
        @endphp
        @if($lastResult['resulttype'] == 'random')
            @if($lastResult['randomcolor'] == 'green')
                @php  $textColor = 'Green'; @endphp
            @elseif($lastResult['randomcolor'] == 'green++violet')
                @php  $textColor = 'VioletGreen'; @endphp
            @elseif($lastResult['randomcolor'] == 'red++violet')
                @php  $textColor = 'VioletRed'; @endphp
            @endif
        @endif
        @if($lastResult['resulttype'] == 'real')
            @if($lastResult['color'] == 'green')
                @php  $textColor = 'Green'; @endphp
            @elseif($lastResult['color'] == 'green++violet')
                @php  $textColor = 'VioletGreen'; @endphp
            @elseif($lastResult['color'] == 'red++violet')
                @php  $textColor = 'VioletRed'; @endphp
            @endif
        @endif
            <p>Result <span class="item{{ $textColor }}" style="font-size:16px">{{ $lastResult['resulttype'] == 'random' ? $lastResult['randomresult']:lastResult['result']  }}</span></p>
        </div>
        <div class="col-sm-4 col-xs-4">
            <p>OpenPrice <span class="text-{{ $textColor }}">{{ $lastResult['randomprice'] }}</span></p>
        </div>
    </div>
  </div>
</div>
</div>
</body>
<script>
$(document).ready(function(){
    getResult();

});
function getResult(){
    $.ajax({
        type: 'POST',
        url: '{{ url("/get-records") }} ',
        data: {"_token": "{{ csrf_token() }}"},
        success: function(msg){
            $('#getResult').html(msg);
            //setTimeout(getResult, 180000);
            $('.resultBox').animate({scrollLeft: 1000000000}, 500);
        }
    });
}
</script>
</html>
